/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.core.MicroRuntime;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;

public class MicroBoot {
    private static Logger logger = Logger.getMyLogger("jade.MicroBoot");

    public static void main(String[] args) {
        String propsFile = null;
        try {
            Properties props = MicroBoot.parseCmdLineArgs(args);
            propsFile = props.getProperty("conf");
            if (propsFile != null) {
                props.load(propsFile);
            }
            Logger.initialize(props);
            if (props.getProperty("jvm") == null) {
                props.setProperty("jvm", "pjava");
            }
            MicroRuntime.startJADE(props, new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    logger.log(8, "Exiting now!");
                    System.exit(0);
                }
            });
        }
        catch (IllegalArgumentException iae) {
            logger.log(10, "Error reading command line configuration properties. " + iae.getMessage());
            iae.printStackTrace();
            MicroBoot.printUsage();
            System.exit(-1);
        }
        catch (IOException ioe) {
            logger.log(10, "Error reading configuration properties from file " + propsFile + ".", ioe);
            MicroBoot.printUsage();
            System.exit(-1);
        }
    }

    private static Properties parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String name = args[i].substring(1);
                if (++i >= args.length) {
                    throw new IllegalArgumentException("No value specified for property \"" + name + "\"");
                }
                props.setProperty(name, args[i]);
                continue;
            }
            if (props.getProperty("agents") != null && logger.isLoggable(9)) {
                logger.log(9, "WARNING: overriding agents specification set with the \"-agents\" option");
            }
            String agents = args[i];
            props.setProperty("agents", args[i]);
            if (++i >= args.length) break;
            if (logger.isLoggable(9)) {
                logger.log(9, "WARNING: ignoring command line argument " + args[i] + " occurring after agents specification");
            }
            if (agents != null && agents.indexOf(40) != -1 && !agents.endsWith(")") && logger.isLoggable(9)) {
                logger.log(9, "Note that agent arguments specifications must not contain spaces");
            }
            if (args[i].indexOf(58) == -1 || !logger.isLoggable(9)) break;
            logger.log(9, "Note that agent specifications must be separated by a semicolon character \";\" without spaces");
            break;
        }
        return props;
    }

    private static void printUsage() {
        logger.log(Integer.MIN_VALUE, "Usage:");
        logger.log(Integer.MIN_VALUE, "java -cp <classpath> jade.MicroBoot [options] [agents]");
        logger.log(Integer.MIN_VALUE, "Options:");
        logger.log(Integer.MIN_VALUE, "    -conf <file-name>. Read configuration properties from the specified file name");
        logger.log(Integer.MIN_VALUE, "    -host <host-name>. The name/address of the host where the BackEnd has to be created");
        logger.log(Integer.MIN_VALUE, "    -port <port-number>. The port of the J2SE container active on \"host\"");
        logger.log(Integer.MIN_VALUE, "    -<key> <value>");
        logger.log(Integer.MIN_VALUE, "Agents: [-agents] <semicolon-separated agent-specifiers>");
        logger.log(Integer.MIN_VALUE, "     where agent-specifier = <agent-name>:<agent-class>[(comma separated args)]\n");
    }
}

